#!/bin/bash

set -e

function play_album {
    local album_path="$1"
    [ -z "$album_path" ] && album_path="CrystalCastles/CrystalCastlesI"

    local song_names=
    #mapfile -t song_names < <( \
    #  ./media.sh "music/${album_path}" | grep --color=never -Eo '[^ ]+\.mp3$' \
    #)
    mapfile -t song_names < <( \
        ./media.sh "music/${album_path}" | tail -n+4 | cut -d' ' -f3- \
    )

    for song_name in "${song_names[@]}"; do
        echo "Playing: ${song_name}"
        ./media.sh "music/${album_path}/${song_name}" | mpv --quiet -
    done
}

function main {
    while [ $# -gt 0 ]; do
        echo "Playing album: $1"
        play_album "$1"
        shift
    done
}

main "$@"
